//
//  MCSyncChange.h
//  GWSyncServices
//
//  Created by Michael Clark on 16/03/07.
//  Copyright 2007 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCSyncDefines.h"

@interface MCSyncChange : NSObject {
	@protected
	
	MCSyncChangeType      __type;
	MCSyncChangeOutcome   __outcome;
	
	NSString*             __syncServicesRecordIdentifier;
	NSString*             __newSyncServicesRecordIdentifier;
	NSString*             __syncServicesEntityName;
	
	NSNumber*             __applicationRecordIdentifier;
	NSString*             __applicationEntityName;
	
	NSDictionary*         __applicationRecordRepresentation;
	NSDictionary*         __formattedRecordRepresentation;
	
	NSMutableDictionary*  __userInfo;
}




- (MCSyncChangeType)type;
- (void)setType:(MCSyncChangeType)aType;
- (MCSyncChangeOutcome)outcome;
- (void)setOutcome:(MCSyncChangeOutcome)anOutcome;

// Will return the new identifier if not nil otherwise returns syncServiceRecordIdentifier
- (NSString*)effectiveSyncServicesRecordIdentifier;

- (NSString *)syncServicesRecordIdentifier;
- (void)setSyncServicesRecordIdentifier:(NSString *)aSyncServicesRecordIdentifier;
- (NSString *)syncServicesEntityName;
- (void)setSyncServicesEntityName:(NSString *)aSyncServicesEntityName;

- (NSString *)newSyncServicesRecordIdentifier;
- (void)setNewSyncServicesRecordIdentifier:(NSString *)aNewSyncServicesRecordIdentifier;

- (NSNumber *)applicationRecordIdentifier;
- (void)setApplicationRecordIdentifier:(NSNumber *)anApplicationRecordIdentifier;
- (NSString *)applicationEntityName;
- (void)setApplicationEntityName:(NSString *)anApplicationEntityName;
- (NSDictionary *)applicationRecordRepresentation;
- (void)setApplicationRecordRepresentation:(NSDictionary *)anApplicationRecordRepresentation;

- (NSDictionary *)formattedRecordRepresentation;
- (void)setFormattedRecordRepresentation:(NSDictionary *)aFormattedRecordRepresentation;

- (NSMutableDictionary *)userInfo;
- (void)setUserInfo:(NSMutableDictionary *)anUserInfo;
- (void)setUserInfoObject:(id)aUserInfoObject forKey:(id)aKey;
- (void)removeUserInfoObjectForKey:(id)aKey;
- (id)userInfoObjectForKey: (NSString*)key;

@end
